#include <windows>
#include <setupapi>
#include <iostream>
#include <assert>
#include <sysutils.hpp>


using namespace std;

void displayError(const char* msg){
  cout << msg << endl;
  system("PAUSE");
  exit(0);
};
//---------------------------------------------------------
template <class T>
inline void releaseMemory(T &x)
{
  assert(x != NULL);
  delete x;
  x = NULL;
}
//---------------------------------------------------------
typedef USHORT USAGE, *PUSAGE;
typedef struct _HIDP_PREPARSED_DATA *PHIDP_PREPARSED_DATA;
PHIDP_PREPARSED_DATA preparsedData;

typedef struct _HIDP_CAPS {
   USAGE Usage;
   USAGE UsagePage;
   USHORT InputReportByteLength;
   USHORT OutputReportByteLength;
   USHORT FeatureReportByteLength;
   USHORT Reserved[17];
   USHORT NumberLinkCollectionNodes;
   USHORT NumberInputButtonCaps;
   USHORT NumberInputValueCaps;
   USHORT NumberInputDataIndices;
   USHORT NumberOutputButtonCaps;
   USHORT NumberOutputValueCaps;
   USHORT NumberOutputDataIndices;
   USHORT NumberFeatureButtonCaps;
   USHORT NumberFeatureValueCaps;
   USHORT NumberFeatureDataIndices;
} HIDP_CAPS, *PHIDP_CAPS;
//---------------------------------------------------------
typedef struct _HIDP_LINK_COLLECTION_NODE {
   USAGE  LinkUsage;
   USAGE  LinkUsagePage;
   USHORT  Parent;
   USHORT  NumberOfChildren;
   USHORT  NextSibling;
   USHORT  FirstChild;
   ULONG  CollectionType: 8;
   ULONG  IsAlias: 1;
   ULONG  Reserved: 23;
   PVOID  UserContext;
} HIDP_LINK_COLLECTION_NODE, *PHIDP_LINK_COLLECTION_NODE;
//---------------------------------------------------------
HIDP_CAPS capabilities;
PHIDP_LINK_COLLECTION_NODE linkCollectionNodes;

GUID classGuid;
HMODULE hHidLib;
DWORD memberIndex = 0;
DWORD deviceInterfaceDetailDataSize;

HDEVINFO deviceInfoSet;
SP_DEVICE_INTERFACE_DATA deviceInterfaceData;
PSP_DEVICE_INTERFACE_DETAIL_DATA deviceInterfaceDetailData = NULL;

HANDLE  hidDeviceObject;

BYTE *inputReportBuffer; //bufor danych wejsciowych
DWORD numberOfBytesRead = 0;

int main()
{

  void (__stdcall *HidD_GetHidGuid)(OUT LPGUID HidGuid);

  long (__stdcall* HidP_GetCaps)(IN PHIDP_PREPARSED_DATA PreparsedData,
                                 OUT PHIDP_CAPS Capabilities);
  long (__stdcall* HidP_GetLinkCollectionNodes)(OUT PHIDP_LINK_COLLECTION_NODE\
                                               LinkCollectionNodes,
                                IN OUT PULONG LinkCollectionNodesLength,
                                IN PHIDP_PREPARSED_DATA PreparsedData);

  bool (__stdcall* HidD_GetPreparsedData)(IN HANDLE  HidDeviceObject,
                                      OUT PHIDP_PREPARSED_DATA *PreparsedData);

  bool (__stdcall* HidD_FreePreparsedData)(IN PHIDP_PREPARSED_DATA PreparsedData);


  hHidLib = LoadLibrary("HID.DLL");
  if (!hHidLib)
    displayError("Bad doaczenia biblioteki HID.DLL.");

  (FARPROC&) HidD_GetHidGuid=GetProcAddress(hHidLib, "HidD_GetHidGuid");
  (FARPROC&) HidP_GetCaps=GetProcAddress(hHidLib,
                                             "HidP_GetCaps");
  (FARPROC&) HidD_GetPreparsedData=GetProcAddress(hHidLib,
                                             "HidD_GetPreparsedData");
  (FARPROC&) HidD_FreePreparsedData=GetProcAddress(hHidLib,
                                             "HidD_FreePreparsedData");

  (FARPROC&) HidP_GetLinkCollectionNodes=GetProcAddress(hHidLib,
                                          "HidP_GetLinkCollectionNodes");


   if (!HidD_GetHidGuid || !HidP_GetCaps || !HidD_GetPreparsedData
       || !HidD_FreePreparsedData || !HidP_GetLinkCollectionNodes){
      FreeLibrary(hHidLib);
      displayError("Nie znaleziono jednej lub wicej funkcji eksportowych.\n");
   }

   HidD_GetHidGuid(&classGuid);

   deviceInfoSet = SetupDiGetClassDevs(&classGuid, NULL, NULL,
                   DIGCF_PRESENT | DIGCF_INTERFACEDEVICE);
   if (deviceInfoSet == INVALID_HANDLE_VALUE){
      FreeLibrary(hHidLib);
      displayError("Nie zidentyfikowano podczonych urzdze.\n");
   }

   deviceInterfaceData.cbSize = sizeof(SP_DEVICE_INTERFACE_DATA);


   while(SetupDiEnumDeviceInterfaces(deviceInfoSet, NULL, &classGuid,
                                     memberIndex, &deviceInterfaceData)){
       memberIndex++; //inkrementacja numeru interfejsu
       SetupDiGetDeviceInterfaceDetail(deviceInfoSet, &deviceInterfaceData,
                             NULL, 0, &deviceInterfaceDetailDataSize, NULL);
       deviceInterfaceDetailData = (PSP_DEVICE_INTERFACE_DETAIL_DATA)
                              new DWORD[deviceInterfaceDetailDataSize];
       deviceInterfaceDetailData->cbSize=sizeof(SP_DEVICE_INTERFACE_DETAIL_DATA);
       if (!SetupDiGetDeviceInterfaceDetail(deviceInfoSet, &deviceInterfaceData,
            deviceInterfaceDetailData, deviceInterfaceDetailDataSize,
            NULL, NULL)){
          releaseMemory(deviceInterfaceDetailData);
          SetupDiDestroyDeviceInfoList(deviceInfoSet);
          displayError("Nie mona pobra informacji o interfejsie.\n");
       }

       if (NULL != strstr(deviceInterfaceDetailData->DevicePath, "vid_22ba")){
          cout << "\n"<< deviceInterfaceDetailData->DevicePath << "\n";
          hidDeviceObject=CreateFile(deviceInterfaceDetailData->DevicePath,
                                     GENERIC_READ | GENERIC_WRITE, FILE_SHARE_READ,
                                     NULL,OPEN_EXISTING,0,NULL);
          if(hidDeviceObject==INVALID_HANDLE_VALUE)
             displayError("Nie mozna otworzyc urzadzenia do transmisji");
             else
               break;
       }
       releaseMemory(deviceInterfaceDetailData);
   };//koniec while

   SetupDiDestroyDeviceInfoList(deviceInfoSet);

   if(HidD_GetPreparsedData(hidDeviceObject, &preparsedData)){

       HidP_GetCaps(preparsedData, &capabilities);
       printf("Usage=%d\nUsagePage=%d\nInputReportByteLength=%d\n"
           "OutputReportByteLength=%d\nFeatureReportByteLength=%d\n"
           "NumberInputButtonCaps=%d\nNumberInputValueCaps=%d\n\n",
           capabilities.Usage,capabilities.UsagePage,
           capabilities.InputReportByteLength,
           capabilities.OutputReportByteLength,
           capabilities.FeatureReportByteLength,
           capabilities.NumberInputButtonCaps,
           capabilities.NumberInputValueCaps);

       PULONG  linkCollectionNodesLength;

       linkCollectionNodes = new \
       HIDP_LINK_COLLECTION_NODE[capabilities.NumberLinkCollectionNodes];

       HidP_GetLinkCollectionNodes(linkCollectionNodes,
                                   linkCollectionNodesLength,
                                   preparsedData);

       printf("LinkUsage=%d\nLinkUsagePage=%d\nParent=%d\n"
              "NumberOfChildren=%d\nCollectionType=%d\n\n",
              linkCollectionNodes->LinkUsage,
              linkCollectionNodes->LinkUsagePage,
              linkCollectionNodes->Parent,
              linkCollectionNodes->NumberOfChildren,
              linkCollectionNodes->CollectionType);


       inputReportBuffer = new BYTE[capabilities.InputReportByteLength];

       while(true) { //cykliczny odczyt danych z wybranego urzdzenia
          memset(inputReportBuffer, 0x00, capabilities.InputReportByteLength);
          ReadFile(hidDeviceObject, inputReportBuffer,
                   capabilities.InputReportByteLength,
                   &numberOfBytesRead, NULL);
          if(numberOfBytesRead==capabilities.InputReportByteLength){
             for( USHORT i=0; i<capabilities.InputReportByteLength; i++)
                printf("%d ", inputReportBuffer[i]);
                printf("\n");
             }
             else {
                printf("Bledna liczba bajtow odebranych.\n",numberOfBytesRead);
                break;
             }
          if(inputReportBuffer[6]==64) {
             HidD_FreePreparsedData(preparsedData);
             Win32Check(CloseHandle(hidDeviceObject));
             break;
          }
       }
   }
   //if(hidDeviceObject != INVALID_HANDLE_VALUE)
   //   Win32Check(CloseHandle(hidDeviceObject));
   releaseMemory(inputReportBuffer);
   releaseMemory(linkCollectionNodes);
   FreeLibrary(hHidLib);
   cout << endl;
   system("PAUSE");
   return 0;
}
//---------------------------------------------------------

